//
//  NSArray+MCAccessors.h
//  MCFoundation
//
//  Created by aj on Tue Jan 01 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface NSArray (MCAccessors)

// Returns an array of objects - each item in the array is the result of valueForAttribute on each item in the array
- (id)valueForAttribute:(NSString *)key;

// applies valueForAttribute, if an array is returned, the objects within that array are added to the array that is returned (vs. an array of arrays)
- (id)valueForAttributeByFlatteningArrays:(NSString *)key;

- (id)nullSafeValueForAttribute:(NSString *)key;
- (void)setValue:aValue forAttribute:(NSString *)anAttribute;



// takes the result of valueForAttribute and joins then with aString
- (NSString *)valueForAttribute:(NSString *)key joinedByString:(NSString *)aString;

- (NSString *)textRepresentationUsingAttributes:(NSArray *)attribs 
	joinedByString:(NSString *)delim 
	startWrapString:(NSString *)start_wrap 
	endingWrapString:(NSString *)end_wrap;
	
- (NSArray *)dictionaryRepresentationsUsingMapping:(NSDictionary *)mapping;
	
// calls plistRepresentationWithKeys: on each object
- (NSArray *)plistRepresentationsWithKeys:(NSArray*)theKeys;



/*
 valueForFilterString:
 Provides inline filtering (using NSPredicate) and sorting for use with KVC.
 
 valueForUndefinedKey: is overriden for NSArray and if it detects filter|, it redirects the key to this method.
 
 Reserved keywords: filter| 
 					sort| 
					first| 
 					last| 
 					first 
 					last 
 					: (colon)
 
 Usage examples:
 obj = [contacts valueForKeyPath:@"@filter|cachedName like \"A*\", first"];
 	filters the Contacts array for all object that match cachedName and returns the first
 
 objs = [contacts valueForKeyPath:@"@filter|cachedName == \"A*\""];
    filters the contacts array and returns an array of matching objects
 
 obj = [contacts valueForKeyPath:@"@filter|cachedName like \"A*\", last|firstname = ASC"];
 	filters the contacts array, sorts it by firstname in ascending order and returns the last
 
 address = [contact valueForKeyPath:@"geoAddresses.@filter|label:name == \"Main\", first"];
 	gets all the geoAddresses from the contact, then filters by label.name = Main and returns the first
 	NOTE: you have to replace . with : inside the filter and sort commands, other KVC does some funky stuff
 
 Parsing rules:
 Any occurrence of : is replaced with . and then the string broken up at the ", " point. The first part being the filter command and the second the sort command.
 	Strips filter| and then makes and NSPredicate from the remainder and runs that on the array
 	Strips sort|, first|, last|, first, last from the second command and builds a NSSortDescriptor
 	Breaks the sort rule at " = ". The first part becomes the key and second becomes the order. Looks for ASC for ascending, anything else is considered decending
 	Sorts the predicate results and if you have first, or last, returns an object, otherwise returns an array
 
 NOTE: You cannot postpend . after the filter command as this point.
 
 */
- (id)valueForFilterString:(NSString *)key;



@end
